/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.settings.user;

import com.ibm.hwmca.fw.managed.Status;
import com.ibm.hwmca.fw.settings.user.StatusBackgroundConstants;
import java.io.Serializable;

public class StatusBackground
implements Serializable,
Cloneable {
    private Status status;
    private String colorImageName;
    private String patternImageName;
    private transient Object lock;
    private static final String INVALID_IMAGE_NAME = "The 'imageName' argument is unknown.";

    public StatusBackground(Status status, String imageName) {
        if (StatusBackgroundConstants.isValidColorImageName(imageName)) {
            this.colorImageName = imageName;
            this.patternImageName = null;
        } else if (StatusBackgroundConstants.isValidPatternImageName(imageName)) {
            this.patternImageName = this.colorImageName;
            this.colorImageName = null;
        } else {
            throw new IllegalArgumentException(INVALID_IMAGE_NAME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getImageName() {
        Object object = this.getLock();
        synchronized (object) {
            return this.patternImageName == null ? this.colorImageName : this.patternImageName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setImageName(String imageName, boolean color) {
        Object object = this.getLock();
        synchronized (object) {
            if (color) {
                if (!StatusBackgroundConstants.isValidColorImageName(imageName)) throw new IllegalArgumentException(INVALID_IMAGE_NAME);
                this.colorImageName = imageName;
                this.patternImageName = null;
            } else {
                if (!StatusBackgroundConstants.isValidPatternImageName(this.patternImageName)) throw new IllegalArgumentException(INVALID_IMAGE_NAME);
                this.patternImageName = this.colorImageName;
                this.colorImageName = null;
            }
            return;
        }
    }

    public Object clone() {
        StatusBackground clone = null;
        try {
            clone = (StatusBackground)super.clone();
            clone.status = this.status;
            clone.colorImageName = this.colorImageName;
            clone.patternImageName = this.patternImageName;
        }
        catch (CloneNotSupportedException exc) {}
        return clone;
    }

    private Object getLock() {
        if (this.lock == null) {
            this.lock = new Object();
        }
        return this.lock;
    }
}

